import os

BASE_DIR = os.path.dirname(os.path.abspath(__file__))

# Define folders relative to the base directory
UPLOAD_FOLDER = os.path.join(BASE_DIR, "uploads")
TRANSCRIPT_FOLDER = os.path.join(BASE_DIR, "transcripts")

# Make sure these folders exist
os.makedirs(UPLOAD_FOLDER, exist_ok=True)
os.makedirs(TRANSCRIPT_FOLDER, exist_ok=True)

ALLOWED_EXTENSIONS = {"wav", "mp3", "flac", "ogg", "mp4"} # Added mp4, commonly used for audio/video

# Whisper paths (Update these paths to match your actual system setup)
# This should point to the whisper.cpp CLI executable
WHISPER_PATH = os.path.expanduser("~/whisper.cpp/build/bin/whisper-cli")

# --- Model Definitions ---
DEFAULT_MODEL_KEY = "small"

# Dictionary of available models (key: path)
# NOTE: These paths must be manually updated in a real environment to where your ggml models are
AVAILABLE_MODELS = {
    "tiny": os.path.expanduser("~/whisper.cpp/models/ggml-tiny.bin"),
    "base": os.path.expanduser("~/whisper.cpp/models/ggml-base.bin"),
    "small": os.path.expanduser("~/whisper.cpp/models/ggml-small.bin"), # Current default
    "medium": os.path.expanduser("~/whisper.cpp/models/ggml-medium.bin"),
}

# Legacy MODEL_PATH variable for backwards compatibility/simplicity in worker default
MODEL_PATH = AVAILABLE_MODELS.get(DEFAULT_MODEL_KEY)

# Define models that should appear in the UI dropdown
# Key must exist in AVAILABLE_MODELS
WHISPER_UI_MODELS = {
    "tiny": {"name": "Tiny", "size": "32MB"},
    "base": {"name": "Base", "size": "74MB"},
    "small": {"name": "Small", "size": "244MB"},
    "medium": {"name": "Medium", "size": "769MB"},
}

# --- Authentication Configuration ---
# Set to True to enable the /register route for initial user creation.
# Set to False (SECURE DEFAULT) immediately after the first user is created.
REGISTRATION_ENABLED = False